%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Codes for generating the true state for examples in Chapter 3 
% Created by John Harlim 
% Last edited: March 16, 2018  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all, close all
tic

global gamma a omega beta 

% true parameter of the model
gamma = 1/2;
a = 1;
omega = 3/4;
beta = 1;
sigma = zeros(2);
sigma(1,1) = sqrt(1/2);
sigma(2,2) = sqrt(1/2);

% time step 
dt = 0.01;
DT = 0.1;
N = DT/dt;
T = 20000*N;
x = zeros(3,T/N+1);
x(:,1) = randn(3,1);

% Euler-Maruyama
for j=1:T/N
    temp = x(:,j);
    for i=1:N
        temp = temp + dt*triad(temp);
        temp(2:3) = temp(2:3) + sigma*sqrt(dt)*randn(2,1);
    end
    x(:,j+1) = temp;
end

% estimate marginal densities
To = 1;
N2 = T/N-To+1;
axis = [-5:0.1:5];
px = histc(x(1,To:T/N),axis)/N2;
pv1 = histc(x(2,To:T/N),axis)/N2;
pv2 = histc(x(3,To:T/N),axis)/N2;

% compute statistics
Meanx = mean(x,2);
Covx = var(x,[],2);
Skewx = skewness(x,[],2);
Kurtx = kurtosis(x,[],2);

T2 = 4000;
for j=1:3
    acf(j,:) = xcorr(x(j,:),'coeff');
end
acf2 = acf(:,T/N+1:T/N+T2+1);
ctime = .5*DT*(acf(:,T/N+1)+acf(:,T/N+T2))+DT*sum(acf(:,T/N+2:T/N+T2-1),2);

% plot statistics
figure(1)
subplot(2,1,1)
plot(axis,px,'k',axis,pv1,'k--',axis,pv2,'k-.','linewidth',2)
legend('x_1','x_2','x_3')
eval([''])
subplot(2,1,2)

plot(0:DT:DT*T/N,acf(1,T/N+1:2*T/N+1),'k',...
     0:DT:DT*T/N,acf(2,T/N+1:2*T/N+1),'k--',...
     0:DT:DT*T/N,acf(3,T/N+1:2*T/N+1),'k:','linewidth',2)
 
legend('x_1','x_2','x_3')
xlim([0 20])


%eval(['print -deps -r100 striadstats.eps'])
eval(['save triad x dt DT T gamma a omega beta sigma'])
eval(['save triadstats Meanx Covx Skewx Kurtx acf2 ctime px'])

toc